package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import java.util.List;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask for decrementing the position of all persons which follow the deleted person.
 * Created by david on 02.03.16.
 */
public class DecrementPositionOfAllPersonsFromDb extends AsyncTask<String, Integer, List<Person>> {

    private IDecrementPosition iDecrementPosition;
    private List<Person> persons;
    private int startPos;
    private PersonDao personDao;
    private Context context;

    public DecrementPositionOfAllPersonsFromDb(Context context,
                                               IDecrementPosition iDecrementPosition,
                                               List<Person> persons,
                                               int startPos) {
        this.iDecrementPosition = iDecrementPosition;
        this.persons = persons;
        this.startPos = startPos;
        this.context = context;
    }

    @Override
    protected List<Person> doInBackground(String... params) {
        personDao = new PersonDao(context);
        personDao.openWritable();
        for (Person person : persons) {
            if (person.getPosition() >= startPos) {
                person.setPosition(person.getPosition() - 1);
                personDao.update(person);
            }
        }
        return persons;
    }

    @Override
    protected void onPostExecute(List<Person> persons) {
        super.onPostExecute(persons);
        iDecrementPosition.onDecremented(persons);
        personDao.close();

    }

    public interface IDecrementPosition {
        void onDecremented(List<Person> persons);
    }
}
